//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: example of pulse width measurement mode of TCA0   
//****************************************** 
#ifndef	IO_MEM
#define	IO_MEM
#endif  
/*
 * --------------------------------------------------------------------------
 *   HEADER INCLUDE DEFINITIONS
 * --------------------------------------------------------------------------
 */
#include <stdlib.h>
#include "MQ6811.h"
#define SET 1
#define CLR 0
unsigned int pulseWidth;
unsigned int cycleLength;

/*
 * --------------------------------------------------------------------------
 *   FUNCTION DECLARATIONS
 * --------------------------------------------------------------------------
 */
void main(void);
void TCA0PulseMeasInit(void);
void TCA0PulseMeasStart(void);
void TCA0PulseMeasStop(void);
void delay10Us(unsigned int tDelayPer10us);

void delay10Us(unsigned int tDelayPer10us){
	while(tDelayPer10us--){}
}

/*
 ***************************************************************************
 * NAME				:main
 *--------------------------------------------------------------------------
 * MODIFY DATE, by	:2015/06/10
 * DESCRIPTION		:Test program main routine
 * FUNCTION			:-
 * PARAMETER		:-
 *
 * RETURN VALUE		:-
 *
 ***************************************************************************
 */
void main()
{
	unsigned int i = 0;
	unsigned char j = 0;

	P7DR.byte = 0xff;
	P7CR.byte = 0xff;

	P9DR.byte = 0x00;
	P9CR.byte = 0xff;
	
	for (;;) {
		TCA0PulseMeasInit();
		TCA0PulseMeasStart();
		for(i=200;i<2000;i+=100){
			P9DR.bit.b0 = SET;//pules go high
			delay10Us(i);
			P9DR.bit.b0 = CLR;//pules go low
			
			for(j=0;j<16;j++){//just for check result
				if(((pulseWidth>>j)&0x01) == 1){
					P9DR.bit.b1 = SET;//output for test
				}
				else{
					P9DR.bit.b1 = CLR;//output for test
				}
			}
			for(j=0;j<16;j++){
				if(((cycleLength>>j)& 0x01) == 1){
					P7DR.bit.b0 = SET;//output for test
				}
				else{
					P7DR.bit.b0 = CLR;//output for test
				}
			}
		}
		TCA0PulseMeasStop();
	}
	//TCA0Stop();
	
}
/*
 ***************************************************************************
 * NAME				:TCA0PulseMeasInit
 *--------------------------------------------------------------------------
 * MODIFY DATE, by	:2015/06/10, Back
 * DESCRIPTION		:Initialize TCA0 registers
 * FUNCTION			:-
 * PARAMETER		:-
 *
 * RETURN VALUE		:-
 *
 ***************************************************************************
 */

void TCA0PulseMeasInit(void)
{
	P7CR.bit.b2 = CLR;					/* P72 as the pulse measurement input port */
	POFFCR0.bit.b0 = SET;				/* Set TCA0EN = 1 */
	__DI();
	EIRH.bit.b6 = SET;					/* Enable INTTCA0 */
	__EI();
	TA0MOD.byte = 0x16;					/* pulse width measurement, fcgck/2^2 */
	TA0CR.byte = 0x00;
	pulseWidth = 0;
	cycleLength = 0;
}

/*
 ***************************************************************************
 * NAME				:TCA0PulseMeasStart
 *--------------------------------------------------------------------------
 * MODIFY DATE, by	:2015/06/10, Back
 * DESCRIPTION		:Start TCA0 function
 * FUNCTION			:-
 * PARAMETER		:-
 *
 * RETURN VALUE		:-
 *
 ***************************************************************************
 */

void TCA0PulseMeasStart(void)
{
	TA0CR.bit.b0 = SET;
}

/*
 ***************************************************************************
 * NAME				:TCA0PulseMeasStop
 *--------------------------------------------------------------------------
 * MODIFY DATE, by	:2015/06/10, Back
 * DESCRIPTION		:Stop TCA0 function
 * FUNCTION			:-
 * PARAMETER		:-
 *
 * RETURN VALUE		:-
 *
 ***************************************************************************
 */

void TCA0PulseMeasStop(void)
{
	TA0CR.byte = 0x00;
}
